<?php
$db = new SQLite3('db.sqlite');

// --- CONFIG: Webhooks per team ---
$webhooks = [
    'bar'     => 'https://chat.googleapis.com/v1/spaces/AAQAGSf8Rks/messages?key=AIzaSyDdI0hCZtE6vySjMm-WEfRq3CPzqKqqsHI&token=2R_gcEFnLkJdn0T829leNf8JhlxY513naL08PBBJwPA',
    'kitchen' => 'https://chat.googleapis.com/v1/spaces/AAQA4hhI-4c/messages?key=AIzaSyDdI0hCZtE6vySjMm-WEfRq3CPzqKqqsHI&token=plGGi3zOjS2OO_SFO4phPb5uhGuWQEiHBpNT5XZznHU',
    'music'   => 'https://chat.googleapis.com/v1/spaces/AAQAnQl-wyE/messages?key=AIzaSyDdI0hCZtE6vySjMm-WEfRq3CPzqKqqsHI&token=4zK38tWB3S_RijVWnVB6meqQ-fyiTh5jsdyZpKVfCKU'
];

// --- GET POST DATA ---
$bar_drinks        = $_POST['bar_drinks'] ?? '';
$bar_staff         = $_POST['bar_staff'] ?? '';
$bar_hygiene       = $_POST['bar_hygiene'] ?? '';
$kitchen_taste     = $_POST['kitchen_taste'] ?? '';
$kitchen_hygiene   = $_POST['kitchen_hygiene'] ?? '';
$kitchen_ontime    = $_POST['kitchen_ontime'] ?? '';
$kitchen_accuracy  = $_POST['kitchen_accuracy'] ?? '';
$music_quality     = $_POST['music_quality'] ?? '';
$music_playlist    = $_POST['music_playlist'] ?? '';
$music_improvement = $_POST['music_improvement'] ?? '';
$improvement       = $_POST['improvement'] ?? '';
$customer_name     = $_POST['customer_name'] ?? '';
$customer_email    = $_POST['customer_email'] ?? '';
$customer_phone    = $_POST['customer_phone'] ?? '';
$customer_social   = $_POST['customer_social'] ?? '';
$submitted_at      = date('Y-m-d H:i:s');

// --- INSERT INTO DB ---
$stmt = $db->prepare('INSERT INTO feedback (
    bar_drinks, bar_staff, bar_hygiene,
    kitchen_taste, kitchen_hygiene, kitchen_ontime, kitchen_accuracy,
    music_quality, music_playlist, music_improvement,
    improvement,
    customer_name, customer_email, customer_phone, customer_social,
    submitted_at
) VALUES (
    :bar_drinks, :bar_staff, :bar_hygiene,
    :kitchen_taste, :kitchen_hygiene, :kitchen_ontime, :kitchen_accuracy,
    :music_quality, :music_playlist, :music_improvement,
    :improvement,
    :customer_name, :customer_email, :customer_phone, :customer_social,
    :submitted_at
)');

$stmt->bindValue(':bar_drinks', $bar_drinks, SQLITE3_TEXT);
$stmt->bindValue(':bar_staff', $bar_staff, SQLITE3_TEXT);
$stmt->bindValue(':bar_hygiene', $bar_hygiene, SQLITE3_TEXT);
$stmt->bindValue(':kitchen_taste', $kitchen_taste, SQLITE3_TEXT);
$stmt->bindValue(':kitchen_hygiene', $kitchen_hygiene, SQLITE3_TEXT);
$stmt->bindValue(':kitchen_ontime', $kitchen_ontime, SQLITE3_TEXT);
$stmt->bindValue(':kitchen_accuracy', $kitchen_accuracy, SQLITE3_TEXT);
$stmt->bindValue(':music_quality', $music_quality, SQLITE3_TEXT);
$stmt->bindValue(':music_playlist', $music_playlist, SQLITE3_TEXT);
$stmt->bindValue(':music_improvement', $music_improvement, SQLITE3_TEXT);
$stmt->bindValue(':improvement', $improvement, SQLITE3_TEXT);
$stmt->bindValue(':customer_name', $customer_name, SQLITE3_TEXT);
$stmt->bindValue(':customer_email', $customer_email, SQLITE3_TEXT);
$stmt->bindValue(':customer_phone', $customer_phone, SQLITE3_TEXT);
$stmt->bindValue(':customer_social', $customer_social, SQLITE3_TEXT);
$stmt->bindValue(':submitted_at', $submitted_at, SQLITE3_TEXT);
$stmt->execute();
$db->close();

// --- FUNCTION TO SEND TO WEBHOOK ---
function sendToWebhook($webhook, $message) {
    $ch = curl_init($webhook);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['text' => $message]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

// --- SEND ONLY NON-EMPTY SECTIONS ---
if($bar_drinks || $bar_staff || $bar_hygiene){
    $msg = "🍸 *New Bar Feedback*\n\n".
           "Drinks: $bar_drinks\n".
           "Staff: $bar_staff\n".
           "Hygiene: $bar_hygiene\n".
           "💬 Comments: $improvement\n".
           "👤 Customer: $customer_name | $customer_email | $customer_phone | $customer_social";
    sendToWebhook($webhooks['bar'], $msg);
}

if($kitchen_taste || $kitchen_hygiene || $kitchen_ontime || $kitchen_accuracy){
    $msg = "🍽️ *New Kitchen Feedback*\n\n".
           "Taste: $kitchen_taste\n".
           "Hygiene: $kitchen_hygiene\n".
           "On-Time: $kitchen_ontime\n".
           "Accuracy: $kitchen_accuracy\n".
           "💬 Comments: $improvement\n".
           "👤 Customer: $customer_name | $customer_email | $customer_phone | $customer_social";
    sendToWebhook($webhooks['kitchen'], $msg);
}

if($music_quality || $music_playlist || $music_improvement){
    $msg = "🎶 *New Music Feedback*\n\n".
           "Quality: $music_quality\n".
           "Playlist: $music_playlist\n".
           "Improvement: $music_improvement\n".
           "💬 Comments: $improvement\n".
           "👤 Customer: $customer_name | $customer_email | $customer_phone | $customer_social";
    sendToWebhook($webhooks['music'], $msg);
}

// --- THANK YOU PAGE ---
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Thank You | VAIAVAIA CULTURAL CAFE</title>
<style>
body { font-family: 'Segoe UI', sans-serif; text-align:center; background:#fff8f0; color:#333; padding-top:80px;}
h1 { color:#d2691e; }
a { color:#d2691e; text-decoration:none; border:1px solid #d2691e; padding:8px 16px; border-radius:8px;}
a:hover { background:#d2691e; color:#fff; }
</style>
</head>
<body>
<h1>Thank you for your feedback 🙏✨</h1>
<p>Your opinion helps VIA VIA CULTURAL CAFE improve our bar, kitchen & music experience.</p>
<p><a href="index.html">Back to Feedback Form</a></p>
</body>
</html>
<?php exit; ?>
