<?php
$db = new SQLite3('db.sqlite');

$result = $db->query("
    SELECT * FROM feedback
    ORDER BY id DESC
");
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Feedback Dashboard | VIA VIA CULTURAL CAFE</title>
    <style>
        body {
            background:#111;
            color:#f5f5f5;
            font-family: Arial, sans-serif;
            padding:20px;
        }
        h1 {
            color:#e0b973;
        }
        .card {
            background:#1c1c1c;
            padding:15px;
            margin-bottom:15px;
            border-radius:10px;
        }
        .section {
            color:#e0b973;
            font-weight:bold;
            margin-top:10px;
        }
        small {
            color:#aaa;
        }
    </style>
</head>
<body>

<h1>VIA VIA Cultural Cafe – Feedback Dashboard</h1>

<?php while ($row = $result->fetchArray(SQLITE3_ASSOC)): ?>
<div class="card">
    <small>🕒 <?= htmlspecialchars($row['submitted_at']) ?></small>

    <div class="section">🍸 Bar</div>
    Drinks: <?= htmlspecialchars($row['bar_drinks']) ?><br>
    Staff: <?= htmlspecialchars($row['bar_staff']) ?><br>
    Hygiene: <?= htmlspecialchars($row['bar_hygiene']) ?>

    <div class="section">🍽️ Kitchen</div>
    Taste: <?= htmlspecialchars($row['kitchen_taste']) ?><br>
    Hygiene: <?= htmlspecialchars($row['kitchen_hygiene']) ?><br>
    On time: <?= htmlspecialchars($row['kitchen_ontime']) ?><br>
    Accuracy: <?= htmlspecialchars($row['kitchen_accuracy']) ?>

    <div class="section">🎶 Music</div>
    Quality: <?= htmlspecialchars($row['music_quality']) ?><br>
    Playlist: <?= htmlspecialchars($row['music_playlist']) ?><br>
    Improvement: <?= htmlspecialchars($row['music_improvement']) ?>

    <div class="section">💬 General Comment</div>
    <?= nl2br(htmlspecialchars($row['improvement'])) ?>

    <div class="section">👤 Customer (optional)</div>
    Name: <?= htmlspecialchars($row['customer_name']) ?><br>
    Email: <?= htmlspecialchars($row['customer_email']) ?><br>
    Phone: <?= htmlspecialchars($row['customer_phone']) ?><br>
    Social: <?= htmlspecialchars($row['customer_social']) ?>
</div>
<?php endwhile; ?>

</body>
</html>
